/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.bracelet;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.Cinder;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class FlamingBracerItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"resistance").maxLevel(0).build()).ability(AbilityData.builder((String)"pyroclastic").stat(StatData.builder((String)"chance").initialValue(0.1, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"count").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-4820209).borderBottom(-4820209).textured(true).build()).beams(BeamsData.builder().startColor(-54772).endColor(15186478).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"pyroclastic").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        if (this.isSlim()) {
            PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(1, 0).addBox(-2.5f, 1.0f, -2.5f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.2f)).texOffs(1, 10).addBox(-2.5f, 0.75f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.4f)).texOffs(1, 17).addBox(-2.5f, 4.25f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.4f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            PartDefinition partDefinition = right_arm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(20, 4).addBox(-1.625f, 0.2374f, 0.2374f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)).texOffs(20, 0).addBox(-1.625f, -2.2374f, -2.2374f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-1.625f, (float)3.5f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        } else {
            PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 1.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.2f)).texOffs(0, 10).addBox(-3.5f, 0.75f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.4f)).texOffs(0, 17).addBox(-3.5f, 4.25f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.4f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            PartDefinition partDefinition = right_arm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(20, 4).addBox(-1.875f, 0.2374f, 0.2374f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)).texOffs(20, 0).addBox(-1.875f, -2.2374f, -2.2374f, 1.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-2.375f, (float)3.5f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public ResourceLocation getTexture(ItemStack stack) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String suffix = this.isSlim() ? "_slim" : "_wide";
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("textures/item/model/" + id.getPath() + suffix + ".png"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isSlim() {
        return Minecraft.getInstance().getSkinManager().getInsecureSkin(Minecraft.getInstance().getGameProfile()).model() == PlayerSkin.Model.SLIM;
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm"});
    }

    @EventBusSubscriber
    public static class FlamingBracerItemEvent {
        @SubscribeEvent
        public static void onPlayerAttacking(AttackEntityEvent event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            if (!target.isAlive()) {
                return;
            }
            Level level = player.getCommandSenderWorld();
            for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.FLAMING_BRACER.value()))) {
                Item item;
                if (player.getCommandSenderWorld().isClientSide() || !((item = stack.getItem()) instanceof FlamingBracerItem)) continue;
                FlamingBracerItem relic = (FlamingBracerItem)item;
                RandomSource random = level.getRandom();
                if (!relic.isAbilityUnlocked(stack, "pyroclastic") || !target.isOnFire() || player.getAttackStrengthScale(0.5f) < 0.9f) continue;
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                SpellContext context = new SpellContext(player.level(), new Spell(), (LivingEntity)player, (IWrappedCaster)new LivingCaster((LivingEntity)player));
                Vec3 hit = target.getPosition(1.0f);
                SpellResolver resolver = new SpellResolver(context);
                double fireCount = Math.min(relic.getStatValue(stack, "pyroclastic", "count"), (double)MathUtils.multicast((RandomSource)random, (double)relic.getStatValue(stack, "pyroclastic", "chance")));
                int i = 0;
                while ((double)i < fireCount) {
                    Vec3 vec3 = new Vec3(hit.x() - Math.sin(random.nextInt(360)), hit.y(), hit.z() - Math.cos(random.nextInt(360)));
                    Cinder fallingBlock = new Cinder(level, vec3.x(), vec3.y() + (double)(target.getBbHeight() / 2.0f), vec3.z(), BlockRegistry.MAGIC_FIRE.defaultBlockState(), resolver);
                    fallingBlock.setDeltaMovement(vec3.x() - hit.x(), ParticleUtil.inRange((double)0.3, (double)0.5), vec3.z() - hit.z());
                    fallingBlock.setDeltaMovement(fallingBlock.getDeltaMovement().multiply(new Vec3(ParticleUtil.inRange((double)0.1, (double)0.5), 1.0, ParticleUtil.inRange((double)0.1, (double)0.5))));
                    fallingBlock.dropItem = false;
                    fallingBlock.hurtEntities = false;
                    fallingBlock.shooter = player;
                    fallingBlock.setOwner((Entity)player);
                    level.addFreshEntity((Entity)fallingBlock);
                    ShapersFocus.tryPropagateEntitySpell((EnchantedFallingBlock)fallingBlock, (Level)level, (Entity)player, (SpellContext)context, (SpellResolver)resolver);
                    ++i;
                }
            }
        }
    }
}

